<?php

namespace Drupal\field_validation\Form;

use Drupal\Core\Entity\EntityDeleteForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Creates a form to delete FieldValidationRuleSet.
 */
class FieldValidationRuleSetDeleteForm extends EntityDeleteForm {

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Optionally select a field validation rule set before deleting %ruleset', array('%ruleset' => $this->entity->label()));
  }
  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->t('If this field validation rule set is in use on the site, this field validation rule set will be permanently deleted.');
  }

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    return parent::form($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {

    parent::submitForm($form, $form_state);
  }

}
