%Simulate data - Node 2 drives node 1 at a time delay of 1 and 2 

cfg             = [];
cfg.method      = 'ar';
cfg.ntrials     = 200;
cfg.triallength = 1;
cfg.fsample     = 200;
cfg.nsignal     = 2;
%AR model at time lag 1
cfg.params(:,:,1)      = [0.55   0.2; 
                          0      0.55]; %off-diagonal entry simulatea 2->1 influence at the first time delay
%AR model at time lag 2
cfg.params(:,:,2)      = [-0.8 -0.1; 
                           0   -0.8;]; %off-diagonal entry simulates 2->1 influence at the second time delay
cfg.noisecov     = [1 0; 
                    0 1];

data = ft_connectivitysimulation(cfg);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Calculate power, coherence, and Granger causality based on parametric and
%non-parametric estimates 

%calculate the fourier coefficients (non-parametric derivation of power)
cfg        = [];
cfg.method = 'mtmfft';
cfg.taper  = 'dpss'; 
cfg.output = 'fourier';
cfg.tapsmofrq = 3;
cfg.foilim = [0 100];
freq       = ft_freqanalysis(cfg, data);

%freqdescriptives calculates the power spectrum
cfg         = [];
fd          = ft_freqdescriptives(cfg, freq);

%Parametric (auto-regressive model based) derivation of AR coefficients

cfg           = [];
cfg.order     = 2;  %model order of 2, this is known a priori (we simulated the data using a model order of 2)
mdata         = ft_mvaranalysis(cfg, data);

%calculate cross-spectral density and transfer functions associated with the auto-regressive model
cfg        = [];
cfg.method = 'mvar';
cfg.foi    = [0:100];
mfreq      = ft_freqanalysis(cfg, mdata);

%Phase-slope index calculation
cfg           = [];
cfg.method    = 'psi';
cfg.bandwidth = 4;
psi1 = ft_connectivityanalysis(cfg, freq);

%Coherence calculation
cfg           = [];
cfg.method    = 'coh';
coh1 = ft_connectivityanalysis(cfg, freq); 
coh2 = ft_connectivityanalysis(cfg, mfreq); 


%Granger causality calculation
cfg           = [];
cfg.method    = 'granger';
cfg.granger.sfmethod = 'multivariate';
g1 = ft_connectivityanalysis(cfg, freq);
g1 = ft_checkdata(g1, 'cmbrepresentation', 'full');
g2 = ft_connectivityanalysis(cfg, mfreq);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%now plot the output for the various connectivity measures as in Figure 9 b and c
%output variables 1 - nonparam 2 - param

figure;plot(fd.freq, fd.powspctrm(1,:)); hold on
plot(fd.freq, fd.powspctrm(2,:),'r'); 
legend('Power ch 1', 'Power ch 2');
title('Nonparametric Power');

figure;plot(mfreq.freq, squeeze(abs(mfreq.crsspctrm(1,1,:)))); hold on; 
plot(mfreq.freq, squeeze(abs(mfreq.crsspctrm(2,2,:))),'r'); 
legend('Power ch 1', 'Power ch 2');
title('Parametric Power');

figure;plot(g1.freq,squeeze(coh1.cohspctrm(1,2,:))); hold on;
title('Nonparametric Coherence spectrum');

figure;plot(g1.freq,squeeze(coh2.cohspctrm(1,2,:))); hold on
legend('1-2','1-3','2-3');
title('Parametric Coherence spectrum');

figure;plot(g1.freq,squeeze(psi1.psispctrm(1,2,:))); hold on;
plot(g1.freq,squeeze(psi1.psispctrm(2,1,:)),'r'); hold on;
legend('1->2', '2->1');title('PSI nonparametric'); 

figure;plot(g1.freq,squeeze(g1.grangerspctrm(1,2,:)));hold on
plot(g1.freq,squeeze(g1.grangerspctrm(2,1,:)),'r');
title('Granger nonparametric estimates');legend('1->2','2->1')

figure; plot(g1.freq,squeeze(g2.grangerspctrm(1,2,:)));hold on;
plot(g1.freq,squeeze(g2.grangerspctrm(2,1,:)),'r');
legend('1->2','2->1');title('Granger parametric estimates ');

